* Title: 	table2.do
* Version: 	23 May 2018
* Purpose: 	Produce analysis of factors driving difference between regions

*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table2, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip conspuma RegionI PrimeMaleD EducationI UnempB LTJoblessB IndustryI perwt ///
	using dta/census_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Keep only 1980/1990/2000 Census and 2009-2011 ACS
keep if year == 1980 | year == 1990 | year == 2000 | (year>=2009 & year<=2011)

* Pool data for 2009-2011 ACS
replace year = 2010 if year>=2009 & year<=2011

* Fix coding due to post-2006 PUMA change due to Katrina
replace conspuma = 172 if conspuma == 173


*******************************************************************************
* (2) Construct variable for share of college-educated men in 1980
*******************************************************************************

preserve
keep if year==1980
gen CollegeEd = (EducationI == 4)
collapse (sum) Total = PrimeMaleD CollegeEd [pw=perwt], by(conspuma)
gen double CollegeEd_Rate_80 = CollegeEd/Total
keep conspuma CollegeEd_Rate_80
tempfile 1980
save `1980'

restore
merge m:1 conspuma using `1980', assert(matched) nogen


*******************************************************************************
* (3) Merge with state-level institutional controls
*******************************************************************************

* Corruption
merge m:1 statefip using dta/corruption, assert(matched using) keep(matched) nogen

* Right to work
merge m:1 statefip using dta/right_to_work, assert(matched using) keep(matched) nogen

* Licensed share of workforce
merge m:1  statefip using dta/licensing, assert(matched using) keep(matched) nogen

* Save dataset
save output/tables/dta/table2.dta, replace


*******************************************************************************
* (4) Regressions
*******************************************************************************

* Column 1: 2010, no controls
reg UnempB i.RegionI if year==2010 [pw=perwt], vce(cluster statefip)

* Column 2: 2010, individual education + share of population in 1980 with college controls
reg UnempB i.RegionI i.EducationI CollegeEd_Rate_80 if year==2010 [pw=perwt], vce(cluster statefip)

* Column 3: 2010, individual education + share of population in 1980 with college + institutional controls
reg UnempB i.RegionI i.EducationI CollegeEd_Rate_80 ///
	   Average_Corruption RightWork Frac_Licensed if year==2010 [pw=perwt], vce(cluster statefip)

* Column 4: 2000, individual education + share of population in 1980 with college + institutional controls
reg UnempB i.RegionI i.EducationI CollegeEd_Rate_80 ///
	   Average_Corruption RightWork Frac_Licensed if year==2000 [pw=perwt], vce(cluster statefip)

* Column 5: 1990, individual education + share of population in 1980 with college + institutional controls
reg UnempB i.RegionI i.EducationI CollegeEd_Rate_80 ///
	   Average_Corruption RightWork Frac_Licensed if year==1990 [pw=perwt], vce(cluster statefip)

* Column 6: 1980, individual education + share of population in 1980 with college + institutional controls
reg UnempB i.RegionI i.EducationI CollegeEd_Rate_80 ///
	   Average_Corruption RightWork Frac_Licensed if year==1980 [pw=perwt], vce(cluster statefip)


*******************************************************************************
* (5) End of file
*******************************************************************************

log close
exit, clear
